#ifndef AFFICHAGE_H_INCLUDED
#define AFFICHAGE_H_INCLUDED

#include <SDL/SDL.h>
#include <SDL/SDL_ttf.h>

#define TITRE "Kaaptur - Serveur"
#define RESOLUTION_X 640
#define RESOLUTION_Y 480
#define POLICE_TEXTE "ressources/times.ttf"
#define POLICE_TAILLE_NORMALE 14

#define BUFFER_MAX 256

typedef struct s_affichage //Ne sert qu' la concision du code pour le passage d'argument par exemple
{
    SDL_Surface *ecran; //Contient les informations sur la fentre et les donnes  afficher dans celle-ci
    TTF_Font *police_normale; //Contient la police charge pour crire du texte en taille normale
    long dernier_affichage; //Permettent de ne pas saturer le processeur
}t_affichage;

long aff_init(t_affichage *aff); //Initialise le mode video, etc.
void aff_quit(t_affichage *aff); //Libre la mmoire utilise par l'affichage
void afficher_message(SDL_Surface *ecran, char *txt, TTF_Font *police, long rouge, long vert, long bleu); //Affiche le texte dans txt sur ecran aprs avoir fait un scroll de celui-ci
void afficher_saisie(SDL_Surface *ecran, char *txt, TTF_Font *police); //Affiche la saisie txt en cours
void afficher_menu(SDL_Surface *ecran, TTF_Font *police); //Affiche la liste des commandes

#endif // AFFICHAGE_H_INCLUDED
